% GNF demo for self-organization with 'Swiss Roll' 3D distribution

clear
NumSamples = 10000;
MaxNeurons = 50; % Maximum number of neurons in each graph

% The following values of the parameters are those considered in the
% original GNG paper by Fritzke (1995)
Lambda=100;
Epochs=2;
EpsilonB=0.2;
EpsilonN=0.006;
Alpha=0.5;
AMax=50;
D=0.995;

% Generate data ('Swiss Roll' 3D distribution)
Samples = Generate3DSamples(1,NumSamples);         
NumSteps = NumSamples*Epochs;

% GNF Training
[Model] = TrainGNF(Samples,MaxNeurons,Lambda,EpsilonB,EpsilonN,Alpha,AMax,D,NumSteps);

% Plot the Model
GenerateManifolds3D(1,50,1);
hold on;
uistack(gcf,'bottom');
PlotGNF3D(Model);        
axis off
view([-26,8])